% ex7_51ekf.m
% Extended Kalman filter
% Van der Pol equaiton
% Approximation by Euler's method
% clear

x00=[0.2 0.1]';   % initial value
del=0.1;          % sampling interval
d2=sqrt(del);
T=50;             % period of simulation
N=T/del;          % number of sample points
x=zeros(3,N+1);
y=zeros(1,N+1);
R=0.01;          % covariance of observation noise
Q=[0.026  0      % covariance of system noise 
    0   0.01];   %
vd=sqrt(R)*randn(1,N+1);   % observation noise for data
wd=sqrt(Q)*randn(2,N+1);   % system noise for data
eps=1.0;                   % unknown parameter
x(:,1)=[x00;eps];
% data generation
C=[0 1 0];   % y= Cx
for k=1:N
x(1,k+1)=x(1,k)+del*x(2,k)+d2*wd(1,k);
temp=eps*(1-x(1,k)^2)*x(2,k)-x(1,k);
x(2,k+1)=x(2,k)+del*temp+d2*wd(2,k);
x(3,k+1)=x(3,k);
y(1,k)=C*x(:,k)+vd(1,k);
end
y(1,N+1)=C*x(:,N+1)+vd(1,N+1);
%
% EKF
var1=zeros(1,N+1);
var2=zeros(1,N+1);
var3=zeros(1,N+1);
% filtering
H=C;
q3=0.00001;
Q=[Q(1,1) 0 0;
   0 Q(2,2) 0;
   0 0   q3];
xep=zeros(3,N+1);    % prediction xe_{t/t-1}
xef=zeros(3,N+1);    % filtering  xe_{t/t}
Pep=zeros(3,3,N+1);  % covariance of prediction P_{t/t-1}
Pef=zeros(3,3,N+1);  % covariance of filtering P_{t/t}
Pep(:,:,1)=[0.5 0 0;
            0 0.5 0;
            0 0 0.5]; % initial covariance of prediction
K=zeros(3,1,N+1);
for k=1:N+1
K(:,:,k)=Pep(:,:,k)*H'/(H*Pep(:,:,k)*H'+R);   % EKF gain
xef(:,k)=xep(:,k) + K(:,:,k)*(y(k)-H*xep(:,k)); 
%
Pef(:,:,k)=inv(inv(Pep(:,:,k))+H'*inv(R)*H);  % covariance of filtering
f21=-del-2*del*xef(1,k)*xef(2,k)*xef(3,k);
f22=1+del*xef(3,k)*(1-x(1,k)*x(1,k));
f23=del*(1-x(1,k)*x(1,k))*x(2,k);
F=[1   del  0;
f21  f22  f23;
0  0  1];
Pep(:,:,k+1)=F*Pef(:,:,k)*F' + Q;   % covarinace of prediction
xep(1,k+1)=xef(1,k)+del*xef(2,k);    % predicted estimate
temp2=xef(3,k)*(1-xef(1,k)^2)*xef(2,k)-xef(1,k);
xep(2,k+1)=xef(2,k)+del*temp2;
xep(3,k+1)=xef(3,k);
var1(k)=Pef(1,1,k);
var2(k)=Pef(2,2,k);
var3(k)=Pef(3,3,k);
end
% state estimation error
Et=zeros(1,N+1);
for k=1:N+1
Et(k)=sqrt((x(1,k)-xef(1,k))^2+(x(2,k)-xef(2,k))^2);
end

t=0:N;
t=t*del;

figure(1)
plot(t,x(1,1:N+1),'r',t,xef(1,1:N+1),'b','LineWidth',1.5)
xlabel('Time t (sec)')
title('Estimation of x_{1t} by EKF')
axis([0,T,-4,4]);
grid
legend('True x_1','Filtered estimate by EKF')

figure(2)
plot(t,x(2,1:N+1),'r',t,xef(2,1:N+1),'b','LineWidth',1.5)
xlabel('Time t (sec)')
title('Estimation of x_{2t} by EKF')
axis([0,T,-4,4]);
grid
legend('True x_2','Filtered estimate by EKF')

figure(3)
plot(t,Et,'b-','LineWidth',1.3)
xlabel('Time t (sec)')
title('Fig. 7.5a: State estimation error by EKF')
axis([0 T 0 2])
grid
legend('State estimation error by EKF')
hold on


figure(4)
plot(t,x(3,1:N+1),'r',t,xef(3,1:N+1),'b-','LineWidth',1.5)
xlabel('Time t (sec)')
title('Fig. 7.5b: Parameter estimation by EKF')
axis([0,T,-1,2]);
grid
legend('True \epsilon=1','Estimate by EKF')
hold on
